<?php

class ControllerExtensionPaymentObmenka extends Controller {

    private $order;

    private static $obmenka_pay_url = 'https://acquiring.obmenka.ua/acs';

    public function __construct($registry) {

        parent::__construct($registry);
        $this->load->language('extension/payment/obmenka');

    }

	/* Form */
    public function index() {

        $this->confirm();
        $data = array();
        $data['button_confirm'] = $this->language->get('button_confirm');
        $data['action'] = self::$obmenka_pay_url;
        $data['form_fields'] = $this->form_fields();

        return $this->load->view('extension/payment/obmenka', $data);

    }

	/* Order Confirmation */
    public function confirm() {

		if ($this->session->data['payment_method']['code'] !== 'obmenka') {
			return false;
		}
		if (empty($this->session->data['order_id'])) {
			return false;
		}

		$set_status = $this->config->get('payment_obmenka_order_status_confirm');
		if (!$set_status) {
			return false;
		}

		$this->load->model('checkout/order');
		$this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $set_status);

    }

	/* Form Generation */
    protected function form_fields($order_id = false) {

        $this->load->model('checkout/order');

		/* Order Information */
        if (!$order_id) {

            if (isset($this->session->data['order_id'])) {
                $order_id = $this->session->data['order_id'];
            }
			else {
                die($this->language->get('error_fail_checkout_extension'));
            }

        }
        $order_info = $this->model_checkout_order->getOrder($order_id);

		/* Total */
		$total = $order_info['total'];
		$total = number_format($this->currency->convert($total, $this->config->get('config_currency'), $order_info['currency_code'], 2, '.', ''));

		/* Success / Fail / Status URL */
        $obmenka_success_url = HTTPS_SERVER.'index.php?route=extension/payment/obmenka/success&order='.$order_id;
        $obmenka_fail_url = HTTPS_SERVER.'index.php?route=extension/payment/obmenka/fail&order='.$order_id;
        $obmenka_status_url = HTTPS_SERVER.'index.php?route=extension/payment/obmenka/status/&order='.$order_id;

		$total = explode(',', $total);

    if ($order_info['currency_code'] == "RUB") {
      $order_info['currency_code'] = "RUR";
    }


		$form_data = array(

			'CLIENT_ID' => $this->config->get('payment_obmenka_client_id'),
			'INVOICE_ID' => $order_id,
			'AMOUNT' => $total[0].$total[1],
			'CURRENCY' => $order_info['currency_code'],
			'DESCRIPTION' => 'Оплата заказа #'.$order_id,
			'SUCCESS_URL' => $obmenka_success_url,
			'FAIL_URL' => $obmenka_fail_url,
			'STATUS_URL' => $obmenka_status_url,

		);

		/* Sign Generation */
		$obmenka_secret_key = $this->config->get('payment_obmenka_secret_key');
		$sign = base64_encode(md5($obmenka_secret_key.base64_encode(sha1(implode('', $form_data), true)).$obmenka_secret_key, true));

		$form_data['SIGN_ORDER'] = implode(';', array_keys($form_data));
		$form_data['SIGN'] = $sign;

        return $form_data;

    }

	/* Status */
	public function status() {
    $payment_id = $_REQUEST['order'];
    $FormData = ['payment_id' => $_REQUEST['order'],

];
  //  $processor_data = fn_get_payment_method_data($payment_id);
    $secret_key = $this->config->get('payment_obmenka_secret_key');
    $client_id = $this->config->get('payment_obmenka_client_id');

    $data = json_encode($FormData);
    $sign = base64_encode(md5($secret_key . base64_encode(sha1($data, true)) . $secret_key, true));

    $headers = array(
        'DPAY_SECURE: ' . $sign,
        'DPAY_CLIENT: ' . $client_id,
        'Content-type: application/json',

    );

    $url = "https://acquiring_api.obmenka.ua/api/einvoice/status";

    $post_data = array(
        "payment_id" => $_REQUEST['order']
    );
    $post_data = json_encode($post_data);
    $FormData = json_encode($FormData);
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $FormData);

    $output = curl_exec($ch);

    curl_close($ch);

    $unswer = json_decode($output);




    if ($unswer->status == 'FAILED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_fail');
      // if (!$set_status) {
      //   $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
      // }
      if (!isset($this->session->data['order_id'])) {
          $this->session->data['order_id'] = $_REQUEST['order'];
      }

      $this->load->model('checkout/order');
      $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
      $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }
    else if ($unswer->status == 'FINISHED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_success');
      // if (!$set_status) {
      //   $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
      // }

          if (!isset($this->session->data['order_id'])) {
              $this->session->data['order_id'] = $_REQUEST['order'];
          }

      $this->load->model('checkout/order');
      $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
          $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));

    }
    else if ($unswer->status == 'CANCELED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_fail');
     // if (!$set_status) {
     //   $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
     // }
     if (!isset($this->session->data['order_id'])) {
         $this->session->data['order_id'] = $_REQUEST['order'];
     }

     $this->load->model('checkout/order');
     $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
     $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }
    else
    {
      // $set_status = $this->config->get('payment_obmenka_order_status_fail');
      // if (!$set_status) {
      //   $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
      // }
      //
      // $this->load->model('checkout/order');
      // $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $set_status);
      // $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }






		// $fopen = fopen('t.txt', 'a');
		// fwrite($fopen, print_r($_REQUEST, true));
		// fclose($fopen);
    //
		// if ($this->request->server['REQUEST_METHOD'] == 'POST') {
    //
		// 	$result = $this->request->post;
		// 	$order_id = (int)$result['INVOICE_ID'];
    //
    //         $this->load->model('checkout/order');
    //         $order = $this->model_checkout_order->getOrder($order_id);
    //
		// }

	}

	/* Fail */
    public function fail() {

      $payment_id = $_REQUEST['order'];
      $FormData = ['payment_id' => $_REQUEST['order'],

  ];
    //  $processor_data = fn_get_payment_method_data($payment_id);
      $secret_key = $this->config->get('payment_obmenka_secret_key');
      $client_id = $this->config->get('payment_obmenka_client_id');

      $data = json_encode($FormData);
      $sign = base64_encode(md5($secret_key . base64_encode(sha1($data, true)) . $secret_key, true));

      $headers = array(
          'DPAY_SECURE: ' . $sign,
          'DPAY_CLIENT: ' . $client_id,
          'Content-type: application/json',

      );

      $url = "https://acquiring_api.obmenka.ua/api/einvoice/status";

      $post_data = array(
          "payment_id" => $_REQUEST['order']
      );
      $post_data = json_encode($post_data);
      $FormData = json_encode($FormData);
      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $FormData);

      $output = curl_exec($ch);

      curl_close($ch);

      $unswer = json_decode($output);



      if ($unswer->status == 'FAILED')
      {
        $set_status = $this->config->get('payment_obmenka_order_status_fail');
        if (!$set_status) {
          $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
        }

        $this->load->model('checkout/order');
        $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
        $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
      }
      else if ($unswer->status == 'FINISHED')
      {
        $set_status = $this->config->get('payment_obmenka_order_status_success');
        if (!$set_status) {
          $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
        }

            if (!isset($this->session->data['order_id'])) {
                $this->session->data['order_id'] = $this->order['order_id'];
            }

        $this->load->model('checkout/order');
        $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
            $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));

      }
      else if ($unswer->status == 'CANCELED')
      {
        $set_status = $this->config->get('payment_obmenka_order_status_fail');
       if (!$set_status) {
         $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
       }

       $this->load->model('checkout/order');
       $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
       $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
      }
      else
      {
        $set_status = $this->config->get('payment_obmenka_order_status_fail');
        if (!$set_status) {
          $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
        }

        $this->load->model('checkout/order');
        $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
        $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
      }

		// $set_status = $this->config->get('payment_obmenka_order_status_fail');
		// if (!$set_status) {
		// 	$this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
		// }
    //
		// $this->load->model('checkout/order');
		// $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $set_status);
		// $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));

    }

	/* Success */
	public function success() {
    $payment_id = $_REQUEST['order'];
    $FormData = ['payment_id' => $_REQUEST['order'],

];
  //  $processor_data = fn_get_payment_method_data($payment_id);
    $secret_key = $this->config->get('payment_obmenka_secret_key');
    $client_id = $this->config->get('payment_obmenka_client_id');

    $data = json_encode($FormData);
    $sign = base64_encode(md5($secret_key . base64_encode(sha1($data, true)) . $secret_key, true));

    $headers = array(
        'DPAY_SECURE: ' . $sign,
        'DPAY_CLIENT: ' . $client_id,
        'Content-type: application/json',

    );

    $url = "https://acquiring_api.obmenka.ua/api/einvoice/status";

    $post_data = array(
        "payment_id" => $_REQUEST['order']
    );
    $post_data = json_encode($post_data);
    $FormData = json_encode($FormData);
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $FormData);

    $output = curl_exec($ch);

    curl_close($ch);

    $unswer = json_decode($output);




    if ($unswer->status == 'FAILED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_fail');
  		if (!$set_status) {
  			$this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
  		}

  		$this->load->model('checkout/order');
  		$this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
  		$this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }
    else if ($unswer->status == 'FINISHED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_success');
  		if (!$set_status) {
  			$this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
  		}

          if (!isset($this->session->data['order_id'])) {
              $this->session->data['order_id'] = $_REQUEST['order'];
          }

  		$this->load->model('checkout/order');
  		$this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
          $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));

    }
    else if ($unswer->status == 'CANCELED')
    {
      $set_status = $this->config->get('payment_obmenka_order_status_fail');
     // if (!$set_status) {
     //   $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
     // }

     $this->load->model('checkout/order');
     $this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
     $this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }
    else
    {
      $set_status = $this->config->get('payment_obmenka_order_status_fail');
  		if (!$set_status) {
  			$this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
  		}

  		$this->load->model('checkout/order');
  		$this->model_checkout_order->addOrderHistory($_REQUEST['order'], $set_status);
  		$this->response->redirect($this->url->link('checkout/failure', '', 'SSL'));
    }





	}

}
