<?php

class ControllerExtensionPaymentObmenka extends Controller {
	
    private $error = array();
	
    public function __construct($registry) {
		
        parent::__construct($registry);
        $this->load->language('extension/payment/obmenka');
        $this->document->setTitle($this->language->get('heading_title'));
		
    }
	
	/* Settings Page */
    public function index() {
    
        $data = $this->language->all();
		
		/* Saving Settings */
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate_settings()) {
			
			/* Clear Data */
            $post_data = $this->request->post;
			foreach ($post_data as $key => $value) {
				
				if (is_array($value)) {
					continue;
				}
				
				$post_data[$key] = trim(strip_tags($value));
				
			}
			
            $post_data['payment_obmenka_total'] = str_replace(',', '.', $post_data['payment_obmenka_total']);
            
			/* Saving & Redirect */
			$this->load->model('setting/setting');
            $this->model_setting_setting->editSetting('payment_obmenka', $this->request->post);
            $this->session->data['success'] = sprintf($this->language->get('text_success'), $this->language->get('heading_title'));

            $this->response->redirect($this->create_url('extension/payment/obmenka'));
			
        }

        $this->load->model('localisation/language');
        $this->load->model('localisation/order_status');
		
		/* Check Permission */
        $permission = $this->validate_permission();
        if (!$permission) {
            $this->error['warning'][] = sprintf($this->language->get('error_permission'), $this->language->get('heading_title'));
        }

        if (!empty($this->session->data['success'])) {
			
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
			
        }

        $data['title_default'] = explode(',', $this->language->get('heading_title'));
        $data['action'] = $this->create_url('extension/payment/obmenka');
        $data['cancel'] = $this->create_url('marketplace/extension');
        $data['payment_obmenka_success_url'] = HTTPS_CATALOG.'index.php?route=extension/payment/obmenka/success';
        $data['payment_obmenka_fail_url'] = HTTPS_CATALOG.'index.php?route=extension/payment/obmenka/fail';
        $data['payment_obmenka_status_url'] = HTTPS_CATALOG.'index.php?route=extension/payment/obmenka/status';
        $data['permission'] = $permission;
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_client_id'] = isset($this->error['error_client_id']) ? $this->error['error_client_id'] : '';
        $data['error_secret_key'] = isset($this->error['error_secret_key']) ? $this->error['error_secret_key'] : '';
        $data['error_test_key'] = isset($this->error['error_test_key']) ? $this->error['error_test_key'] : '';
		
        $data['oc_languages'] = $this->model_localisation_language->getLanguages();

        $data['breadcrumbs'][] = array(
		
           'href' => $this->create_url('common/dashboard'),
           'text' => $this->language->get('text_home')
		   
        );
        
        $data['breadcrumbs'][] = array(
		
           'href' => $this->create_url('marketplace/extension'),
           'text' => $this->language->get('text_extension')
		   
        );
        
        $data['breadcrumbs'][] = array(
		
           'href' => $this->create_url('extension/payment/obmenka'),
           'text' => $this->language->get('heading_title')
		   
        );

        $data['test_modes'] = array(
		
            '0' => $this->language->get('text_disabled'),
            '1' => $this->language->get('text_enabled'),
			
        );

        $this->prepare_settings($data);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/obmenka', $data));
		
    }
	
	/* Get Settings from DB / POST */
    public function prepare_settings(&$data) {
		
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $list_settings = array(
		
            'payment_obmenka_status',
            'payment_obmenka_client_id',
            'payment_obmenka_secret_key',
            'payment_obmenka_test_key',
            'payment_obmenka_success_url',
            'payment_obmenka_fail_url',
            'payment_obmenka_status_url',
            'payment_obmenka_sort_order',
            'payment_obmenka_total',
            'payment_obmenka_order_status_confirm',
            'payment_obmenka_order_status_success',
            'payment_obmenka_order_status_fail',
            'payment_obmenka_langdata',
			
        );

        foreach ($list_settings as $setting) {
			
            if (isset($this->request->post[$setting])) {
                $data[$setting] = $this->request->post[$setting];
            } 
			else {
                $data[$setting] = $this->config->get($setting);
            }
			
        }
			
        return $data;
		
    }
	
	/* Form Validation */
    protected function validate_settings() {
		
		/* Required Fields */
		$required = array(
		
			'payment_obmenka_client_id' => $this->language->get('entry_client_id'),
			'payment_obmenka_secret_key' => $this->language->get('entry_secret_key'),
		
		);
		
        if (!$this->validate_permission()) {
            $this->error['warning'][] = sprintf($this->language->get('error_permission'), $this->language->get('heading_title'));
        } 
		else {
			
			$post_data = $this->request->post;
			
			/* Validate Required Fields */
			foreach ($required as $field_key => $field_name) {
				
				if (!isset($post_data[$field_key])) {
					
					$this->error['warning'][] = sprintf($this->language->get('error_form'), $field_name);
					continue;
					
				}
				
				$this_value = trim($post_data[$field_key]);
				if (empty($this_value)) {

					$this->error['warning'][] = sprintf($this->language->get('error_form'), $field_name);
					continue;
					
				}
				
			}
			
        }

        return !$this->error;
		
    }
	
	/* Function Checks if current user has a permission to modify plugin's settings */
    protected function validate_permission() {
        return $this->user->hasPermission('modify', 'extension/payment/obmenka');
    }

    protected function create_url($route, $url = '') {
		
		$url = $this->url->link($route, $url.'&user_token='.$this->session->data['user_token'], 'SSL'); 
        return str_replace('&amp;', '&', $url);
		
    }

}