<?php

defined('_JEXEC') or die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

/**
 *
 * @author rusty
 * @version $Id: obmenkaua.php$
 * @package VirtueMart
 * @subpackage payment
 * @copyright Copyright (C) 2015 - 2019 VirtueMart - All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 */
if (!class_exists('vmPSPlugin'))
require(VMPATH_PLUGINLIBS . DS . 'vmpsplugin.php');

class plgVmPaymentObmenkaua extends vmPSPlugin {

    public static $_this = false;

    function __construct(& $subject, $config) {

        parent::__construct($subject, $config);

        $this->_loggable = true;
        $this->tableFields = array_keys($this->getTableSQLFields());
        $this->_tablepkey = 'id';
        $this->_tableId = 'id';

        $varsToPush = array(
            'obmenkaua_client_id' => array('', 'char'),
            'obmenkaua_sign' => array('', 'char'),
            'obmenkaua_seller_id' => array('', 'char'),
            'obmenkaua_secret_word' => array('', 'char'),
            'payment_currency' => array('', 'int'),
            'payment_logos' => array('', 'char'),
            'sandbox' => array(0, 'char'),
            'debug' => array(0, 'int'),
            'status_pending' => array('', 'char'),
            'status_success' => array('', 'char'),
            'status_canceled' => array('', 'char'),
            'countries' => array(0, 'char'),
            'min_amount' => array(0, 'int'),
            'max_amount' => array(0, 'int'),
            'cost_per_transaction' => array(0, 'int'),
            'cost_percent_total' => array(0, 'int'),
            'tax_id' => array(0, 'int')
        );
		$this->addVarsToPushCore($varsToPush, 1);
        $this->setConfigParameterable($this->_configTableFieldName, $varsToPush);

    }

    function _getObmenkauaDetails($method)
    {
        $obmenkauaDetails = array(
            'seller_id' => $method->obmenkaua_client_id,
            'obmenkaua_client_id' => $method->obmenkaua_client_id,
            'obmenkaua_sign'=>$method->obmenkaua_sign,
            'secret_word' => $method->obmenkaua_sign,
            'env' => $method->sandbox ? 'https://acquiring.obmenka.ua/acs' : 'https://acquiring.obmenka.ua/acs'
        );

        return $obmenkauaDetails;
    }

    public function getVmPluginCreateTableSQL() {

        return $this->createTableSQL('Payment Obmenkaua Table');
    }

    function getTableSQLFields() {

        $SQLfields = array(
            'id' => 'int(11) unsigned NOT NULL AUTO_INCREMENT ',
            'virtuemart_order_id' => 'int(11) UNSIGNED',
            'order_number' => 'char(32)',
            'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
            'payment_name' => 'char(255) NOT NULL DEFAULT \'\' ',
            'payment_order_total' => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\' ',
            'payment_currency' => 'char(3) ',
            'cost_per_transaction' => 'decimal(10,2) ',
            'cost_percent_total' => 'decimal(10,2) ',
            'tax_id' => 'smallint(1) ',
            'obmenkaua_response' => 'varchar(255)  ',
            'obmenkaua_response_order_number' => 'char(20) '
        );
        return $SQLfields;
    }

    function plgVmConfirmedOrder($cart, $order) {

        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        $session = JFactory::getSession();
        $return_context = $session->getId();
        $this->_debug = $method->debug;

        if (!class_exists('VirtueMartModelCurrency'))
            require(VMPATH_ADMIN . DS . 'models' . DS . 'currency.php');

        $new_status = '';

        $usrBT = $order['details']['BT'];
                $address = ((isset($order['details']['BT'])) ? $order['details']['BT'] : $order['details']['ST']);

        if (!class_exists('TableVendors'))
        require(VMPATH_ADMIN . DS . 'table' . DS . 'vendors.php');
        $vendorModel = VmModel::getModel('Vendor');
        $vendorModel->setId(1);
        $vendor = $vendorModel->getVendor();
        $vendorModel->addImages($vendor, 1);
        $this->getPaymentCurrency($method);
        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->currency_id. '" ';
        $db = JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();




        $paymentCurrency = CurrencyDisplay::getInstance($method->payment_currency);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order['details']['BT']->order_total, false), 2);
        $cd = CurrencyDisplay::getInstance($cart->pricesCurrency);

        $obmenkauaDetails = $this->_getObmenkauaDetails($method);

        if (empty($obmenkauaDetails['obmenkaua_client_id'])) {
            vmInfo(vmText::_('VMPAYMENT_OBMENKAUA_SELLER_ID_NOT_SET'));
            return false;
        }
        $currency_model = VmModel::getModel('currency');
        $order_currency_code = $currency_model->getCurrency($order['details']['BT']->order_currency );

        if ($method->sandbox == 1){

            $amount = "1000";

        }else{
            $amount =$totalInPaymentCurrency;

        }



        $testReq = $method->debug == 1 ? 'YES' : 'NO';
        $post_variables = array(
            "CLIENT_ID" => $obmenkauaDetails['obmenkaua_client_id'],

            "INVOICE_ID" => $order['details']['BT']->order_number,

            "AMOUNT" => $amount,
         //   "CURRENCY" => $order_currency_code->currency_code_3,
            "CURRENCY" =>$currency_code_3,
            "DESCRIPTION" => vmText::_('VMPAYMENT_OBMENKAUA_ORDER_NUMBER') . ': ' . $order['details']['BT']->order_number,
           "SUCCESS_URL" => $this->getSuccessUrl ($order),
            "FAIL_URL" => $this->getCancelUrl ($order),
            "STATUS_URL" => $this->getNotificationUrl($order)


        );




        $data = $post_variables;
        $secret = $obmenkauaDetails['secret_word'];
         $sign = base64_encode(md5($secret . base64_encode(sha1(implode("", $data), true)) . $secret, true));

        $data["SIGN_ORDER"] = implode(";", array_keys($data));
        $data["SIGN"] = $sign;




        // Prepare data that should be stored in the database
        $dbValues['order_number'] = $order['details']['BT']->order_number;
        $dbValues['payment_name'] = $this->renderPluginName($method, $order);
        $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
        $dbValues['obmenkaua_custom'] = $return_context;
        $dbValues['cost_per_transaction'] = $method->cost_per_transaction;
        $dbValues['cost_percent_total'] = $method->cost_percent_total;
        $dbValues['payment_currency'] = $method->payment_currency;
        $dbValues['payment_order_total'] = $totalInPaymentCurrency;
        $dbValues['tax_id'] = $method->tax_id;
        $this->storePSPluginInternalData($dbValues);

        // add html form
        $html = '<div style="margin: auto; text-align: center;">';
        $html .= '<form action="' . $obmenkauaDetails["env"] . '" method="post" id="vmPaymentForm" >';
        foreach ($data as $name => $value) {
            $html.= '<input type="hidden" name="' . $name . '" value="' . htmlspecialchars($value) . '" />';
        }
        $html.= '<input type="submit" id="obmenkaua_submit" class="vm-button-correct" style="display:none" value="' . vmText::_('VMPAYMENT_OBMENKAUA_BUTTON_MESSAGE') . '" />';
        $html.= '</form></div><br />';



        vmJsApi::addJScript('vm.paymentFormAutoSubmit', '
  			jQuery(document).ready(function($){
   				jQuery("body").addClass("vmLoading");
  				var msg="'.vmText::_('VMPAYMENT_OBMENKAUA_REDIRECT_MESSAGE').'";
   				jQuery("body").append("<div class=\"vmLoadingDiv\"><div class=\"vmLoadingDivMsg\">"+msg+"</div></div>");
    			jQuery("#vmPaymentForm").submit();
    			window.setTimeout("jQuery(\'.vmLoadingDiv\').hide();",5000);
    			window.setTimeout("jQuery(\'#obmenkaua_submit\').show();", 5000);
			})
		');


        return $this->processConfirmedOrderPaymentResponse(2, $cart, $order, $html, $dbValues['payment_name'], $new_status);
    }

    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        $this->getPaymentCurrency($method);
        $paymentCurrencyId = $method->payment_currency;
    }

    function plgVmOnPaymentResponseReceived(&$html) {

        $virtuemart_paymentmethod_id = vRequest::getInt('pm', 0);
        $order_number = vRequest::getVar('on', 0);  //?



        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        if (!class_exists('VirtueMartCart'))
        require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
        if (!class_exists('shopFunctionsF'))
        require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		// setup response html
        vmLanguage::loadJLang('com_virtuemart');
        $modelOrder = VmModel::getModel('orders');
        
        $obmenkaua_data = vRequest::getRequest();
        $payment_name = $this->renderPluginName($method);


        if (!empty($obmenkaua_data)) {

            vmdebug('plgVmOnPaymentResponseReceived', $obmenkaua_data);
            $order_number = $obmenkaua_data['on'];

            $virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number);

            if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
                vmError( $order_number.'  obmenka  plgVmOnPaymentResponseReceived NOT getOrderIdByOrderNumber');
                return NULL;
            }


            if ($virtuemart_order_id) {
                $order = $modelOrder->getOrder($virtuemart_order_id);
                $customer_total = (number_format((float)$order['details']['BT']->order_total, 2, '.', ''));
                $payment_name = $this->renderPluginName($method);

                $order['customer_notified']=1;
               // $order['order_status'] = $this->_getPaymentStatus($method, $virtuemart_paymentmethod_id,  $order_number, $customer_total);
               // $order['comments'] = vmText::sprintf('VMPAYMENT_OBMENKAUA_PAYMENT_STATUS_CONFIRMED', $order_number);
                // send the email ONLY if payment has been accepted

                $nb_history = count($order['history']);
                if ($order['history'][$nb_history - 1]->order_status_code != $order['order_status']) {
                    $this->_storeObmenkauaInternalData($method, $obmenkaua_data, $virtuemart_order_id);
                    $this->logInfo('plgVmOnPaymentResponseReceived, sentOrderConfirmedEmail ' . $order_number, 'message');
                    $order['virtuemart_order_id'] = $virtuemart_order_id;
                    $order['comments'] = vmText::sprintf('VMPAYMENT_OBMENKAUA_EMAIL_SENT');
                    $modelOrder->updateStatusForOneOrder($virtuemart_order_id, $order, true);
                }

                $obmenkaua_data['total'] = $customer_total;
                $obmenkaua_data['order_number'] = $order_number;

                $currency_model = VmModel::getModel('currency');
                $obmenkaua_data['currency_code'] = $currency_model->getCurrency($order['details']['BT']->order_currency );




                $html = $this->_getPaymentResponseHtml($obmenkaua_data, $payment_name);
                $link=	JRoute::_("index.php?option=com_virtuemart&view=orders&layout=details&order_number=".$order['details']['BT']->order_number."&order_pass=".$order['details']['BT']->order_pass, false) ;
        		$html .='<br />
        		<a class="vm-button-correct" href="'.$link.'">'.vmText::_('VMPAYMENT_OBMENKAUA_VIEW_ORDER').'</a>';
            } else {
                vmError('Obmenkaua data received, but no order number');
                return;
            }
        } else {
            $virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number);
        }

        $cart = VirtueMartCart::getCart();
        $cart->emptyCart();
        return true;
    }

    function plgVmOnUserPaymentCancel() {

        if (!class_exists('VirtueMartModelOrders'))
        require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );

        $order_number = vRequest::getVar('on');
        if (!$order_number)
        return false;
        $db = JFactory::getDBO();
        $query = 'SELECT ' . $this->_tablename . '.`virtuemart_order_id` FROM ' . $this->_tablename . " WHERE  `order_number`= '" . $order_number . "'";

        $db->setQuery($query);
        $virtuemart_order_id = $db->loadResult();

        if (!$virtuemart_order_id) {
            return null;
        }
        $this->handlePaymentUserCancel($virtuemart_order_id);

        return true;
    }

    function _storeObmenkauaInternalData($method, $obmenkaua_data, $virtuemart_order_id) {

        // get all know columns of the table
        $db = JFactory::getDBO();
        $query = 'SHOW COLUMNS FROM `' . $this->_tablename . '` ';
        $db->setQuery($query);
        $columns = $db->loadColumn(0);
        $post_msg = '';
        foreach ($obmenkaua_data as $key => $value) {
            $post_msg .= $key . "=" . $value . "<br />";
            $table_key = 'obmenkaua_response_' . $key;
            if (in_array($table_key, $columns)) {
                $response_fields[$table_key] = $value;
            }
        }

        $response_fields['payment_name'] = $this->renderPluginName($method);
        $response_fields['obmenkauaresponse_raw'] = $post_msg;
        $return_context = $obmenkaua_data['custom'];
        $response_fields['order_number'] = $obmenkaua_data['merchant_order_id'];
        $response_fields['virtuemart_order_id'] = $virtuemart_order_id;
        $this->storePSPluginInternalData($response_fields, 'virtuemart_order_id', true);
    }

    function _getTablepkeyValue($virtuemart_order_id) {
        $db = JFactory::getDBO();
        $q = 'SELECT ' . $this->_tablepkey . ' FROM `' . $this->_tablename . '` '
        . 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
        $db->setQuery($q);

        if (!($pkey = $db->loadResult())) {
            JError::raiseWarning(500, $db->getErrorMsg());
            return '';
        }
        return $pkey;
    }

    function _getPaymentStatus($method, $key, $order_number, $total) {

            $new_status = $method->status_success;

        return $new_status;
    }

    function plgVmOnShowOrderBEPayment($virtuemart_order_id, $payment_method_id) {

        if (!$this->selectedThisByMethodId($payment_method_id)) {
            return null; // Another method was selected, do nothing
        }

        if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}
		vmLanguage::loadJLang('com_virtuemart');
		$html = '<table class="adminlist table">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE ('COM_VIRTUEMART_PAYMENT_NAME', $paymentTable->payment_name);
		$html .= $this->getHtmlRowBE ('OBMENKAUA_ORDER_NUMBER', $paymentTable->obmenkaua_response_order_number);
		$html .= '</table>' . "\n";
		return $html;

        return $html;
    }

    function _getPaymentResponseHtml($obmenkauaTable, $payment_name) {

        $html = '<table>' . "\n";
        $html .= $this->getHtmlRow('OBMENKAUA_PAYMENT_NAME', $payment_name);
        if (!empty($obmenkauaTable)) {
            $html .= $this->getHtmlRow('OBMENKAUA_ORDER_NUMBER', $obmenkauaTable['order_number']);
            $html .= $this->getHtmlRow('OBMENKAUA_AMOUNT', $obmenkauaTable['total'] . " " . $obmenkauaTable['currency_code']->currency_code_3);
        }
        $html .= '</table>' . "\n";

        return $html;
    }

    function getCosts(VirtueMartCart $cart, $method, $cart_prices) {
        if (preg_match('/%$/', $method->cost_percent_total)) {
            $cost_percent_total = substr($method->cost_percent_total, 0, -1);
        } else {
            $cost_percent_total = $method->cost_percent_total;
        }
        return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
    }


    protected function checkConditions($cart, $method, $cart_prices) {

		return parent::checkConditions($cart, $method, $cart_prices);

    }

    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id) {

        return $this->onStoreInstallPluginTable($jplugin_id);
    }

    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart) {
        return $this->OnSelectCheck($cart);
    }

    public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn) {
        return $this->displayListFE($cart, $selected, $htmlIn);
    }

    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {
        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }

    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array()) {
        return $this->onCheckAutomaticSelected($cart, $cart_prices);
    }

    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {
        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }

    function plgVmonShowOrderPrintPayment($order_number, $method_id) {
        return $this->onShowOrderPrint($order_number, $method_id);
    }

    function plgVmDeclarePluginParamsPayment($name, $id, &$data) {
        return $this->declarePluginParams('payment', $name, $id, $data);
    }

    function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}

    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table) {
        return $this->setOnTablePluginParams($name, $id, $table);
    }


    function   getSuccessUrl ($order) {
        return JURI::root()."index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&pm=" . $order['details']['BT']->virtuemart_paymentmethod_id . '&on=' . $order['details']['BT']->order_number . "&Itemid=" . vRequest::getInt('Itemid'). '&lang='.vRequest::getCmd('lang',''); ;
    }

    function   getCancelUrl ($order) {
        return  JURI::root()."index.php?option=com_virtuemart&view=pluginresponse&task=pluginUserPaymentCancel&pm=" . $order['details']['BT']->virtuemart_paymentmethod_id . '&on=' . $order['details']['BT']->order_number . '&Itemid=' . vRequest::getInt('Itemid').'&lang='.vRequest::getCmd('lang','');
    }

    function   getNotificationUrl ($order) {
        return JURI::root()  .  "index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification&tmpl=component&pm=" . $order['details']['BT']->virtuemart_paymentmethod_id . "&on=" . $order['details']['BT']->order_number . "&lang=".vRequest::getCmd('lang','');
    }

    function plgVmOnPaymentNotification () {

      if (!class_exists ('VirtueMartModelOrders')) {
            require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
        }


    $mb_data = $_REQUEST;




        $order_number = $mb_data['on']; // get order number

        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ( $order_number ))) {


            vmError("no order");
            return;
        }



        if (!($payment = $this->getDataByOrderId ($virtuemart_order_id))) {
            return;
        }
        $payment->virtuemart_paymentmethod_id =$mb_data['pm'];
       // print_r ($payment);

        $method = $this->getVmPluginMethod ($payment->virtuemart_paymentmethod_id);
        $obmenkauaDetails = $this->_getObmenkauaDetails($method);
        $secret = $obmenkauaDetails['secret_word'];
        if (!$payment) {
            vmError('getDataByOrderId payment not found: exit ', 'ERROR');
            return NULL;
        }


       //$this->_storeInternalData ($method, $mb_data, $virtuemart_order_id);

       $order_body = '{"payment_id":"'.$order_number.'"}';



        $DPAY_CLIENT = $obmenkauaDetails['obmenkaua_client_id'];

        $DPAY_SECURE = base64_encode(md5($secret  . base64_encode(sha1( $order_body, true)) . $secret , true));

        $modelOrder = VmModel::getModel ('orders');

        $vmorder = $modelOrder->getOrder ($virtuemart_order_id);
        $order = array();

        // create & initialize a curl session
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://acquiring_api.obmenka.ua/api/einvoice/status");

        curl_setopt($curl, CURLOPT_POSTFIELDS, $order_body);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'DPAY_CLIENT:'. $DPAY_CLIENT,
            'DPAY_SECURE:'. $DPAY_SECURE

        ]);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        $result = json_decode ($output, true);
        print_r ($output);
        $mb_data['payment_status'] = $result['status'];


        $order['customer_notified'] = 1;




        /*
        CREATED - поручение создано,
        PAIN - в процессе списания,
        FINISHED - средства списаны,
        PAYIN_ERROR - списать средства не удалось. Само описание находится в блоке error.
        CANCELED - оплата более не ожидается,
        PAYED_RECALC - счет оплачен, но сумма возмещения пересчитана,
        FAILED - оплата не удалась. ПРИСУТСТВУЕТ ТОЛЬКО В СЧЕТАХ, СОЗДАННЫХ В ТЕСТОВОМ РЕЖИМЕ
        */

        if (strcmp ($mb_data['payment_status'], 'FINISHED') == 0) {
            $order['order_status'] = $method->status_success;
            $order['comments'] = vmText::sprintf ('VMPAYMENT_OBMENKAUA_VIRTUEMART_CONFIRMED', $order_number);
        } elseif ((strcmp ($mb_data['payment_status'], 'Pending') == 0) || (strcmp ($mb_data['payment_status'], 'PAYIN') == 0)) {
            $order['comments'] = vmText::sprintf ('VMPAYMENT_OBMENKAUA_PAYMENT_STATUS_PENDING', $order_number);
            $order['order_status'] = $method->status_pending;
        }
         elseif ((strcmp ($mb_data['payment_status'], 'CANCELED') == 0) || (strcmp ($mb_data['payment_status'], 'FAILED') == 0)) {
            $order['order_status'] = $method->status_canceled;
        }


        $this->logInfo ('plgVmOnPaymentNotification return new_status:' . $order['order_status'], 'message');
       // $order['order_status'] = $method->status_pending;
    print_r (  $order);
        $modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);

        //// remove vmcart
     ///   $this->emptyCart ($payment->user_session, $mb_data['transaction_id']);


    }

    function _storeInternalData ($method, $mb_data, $virtuemart_order_id) {

        // get all know columns of the table
        $db = JFactory::getDBO ();
        $query = 'SHOW COLUMNS FROM `' . $this->_tablename . '` ';
        $db->setQuery ($query);
        $columns = $db->loadColumn (0);

        $post_msg = '';
        foreach ($mb_data as $key => $value) {
            $post_msg .= $key . "=" . $value . "<br />";
            $table_key = 'mb_' . $key;
            if (in_array ($table_key, $columns)) {
                $response_fields[$table_key] = $value;
            }
        }

        $response_fields['payment_name'] = $this->renderPluginName ($method);
        $response_fields['mbresponse_raw'] = $post_msg;
        $response_fields['order_number'] = $mb_data['transaction_id'];
        $response_fields['virtuemart_order_id'] = $virtuemart_order_id;
        $this->storePSPluginInternalData ($response_fields, 'virtuemart_order_id', TRUE);
    }


}

// No closing tag
