<?php
/**
 * @version     2020
 * @author       flance.info
 * @package      Jshopping
 * @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
 * @license      GNU/GPL
 */

defined('_JEXEC') or die('Restricted access');

class pm_obmenkaua extends PaymentRoot{
    const VERSION = '1.0';
    const ORDER_APPROVED = 'approved';
    const ORDER_DECLINED = 'declined';
    const SIGNATURE_SEPARATOR = '|';
    const ORDER_SEPARATOR = ":";
	const URL = 'https://acquiring.obmenka.ua/acs';
	
    /**
     *      
     */
    function loadLanguageFile(){
        $lang = JFactory::getLanguage();
        //   
        $lang_tag = $lang->getTag();
        //     
        $lang_dir = JPATH_ROOT . '/components/com_jshopping/payments/pm_obmenkaua/lang/';
        //       ( )
        $lang_file = $lang_dir . $lang_tag . '.php';

        if(file_exists($lang_file))
            require_once $lang_file;
        else
            require_once $lang_dir . 'en-GB.php';
    }

    function showPaymentForm($params, $pmconfigs){
        include(dirname(__FILE__) . "/paymentform.php");
    }

    /**
     *        . 
     * @param $params   
     */

    function showAdminFormParams($params){
        $module_params_array = array(
            'testmode',
			'obmenkaua_merchant_id',
            'obmenkaua_secret_key',
			'transaction_end_status',
            'transaction_failed_status',
            'transaction_pending_status'
        );
        foreach($module_params_array as $module_param){
            if(!isset($params[$module_param]))
                $params[$module_param] = '';
        }

        $orders = JModelLegacy::getInstance('orders', 'JshoppingModel');
        $this->loadLanguageFile();
        include dirname(__FILE__) . '/adminparamsform.php';
    }



	function showEndForm($pmconfigs, $order){

        $this->loadLanguageFile();

        $lang = JFactory::getLanguage()->getTag();

        switch($lang){
            case 'en_EN':
                $lang = 'en';
                break;
            case 'ru_RU':
                $lang = 'ru';
                break;
            default:
                $lang = 'en';
                break;
        }



        $order_id = $order->order_id;
        $description = 'Order :' . $order_id;
        $base_url = JURI::root() . 'index.php?option=com_jshopping&controller=checkout&task=step7&obmenkaua_merchant_id='.$pmconfigs['obmenkaua_merchant_id'].'&js_paymentclass=' . __CLASS__ . '&order_id=' . $order_id;
        $success_url = $base_url . '&act=finish';
        $fail_url = $base_url . '&act=cancel';
        $cur = $order->currency_code_iso;
        $result_url = $base_url . '&act=notify&nolang=1';


        if ($pmconfigs['testmode'] == 1){

            $amount = "1000";

        }else{
         //   $amount = round($this->fixOrderTotal($order)*100);
            $amount = $this->fixOrderTotal($order);
        }

        $post_variables = array(
            "CLIENT_ID" => $pmconfigs['obmenkaua_merchant_id'],
            "INVOICE_ID" =>  $order_id,
            "AMOUNT" => $amount,
            "CURRENCY" =>$cur,
            "DESCRIPTION" => $description,
            "SUCCESS_URL" =>$success_url,
            "FAIL_URL" => $fail_url,
            "STATUS_URL" => $result_url
        );

        $data = $post_variables;
        $secret = $pmconfigs['obmenkaua_secret_key'];
        $sign = base64_encode(md5($secret . base64_encode(sha1(implode("", $data), true)) . $secret, true));

        $data["SIGN_ORDER"] = implode(";", array_keys($data));
        $data["SIGN"] = $sign;

		?>
		  <html>
        <head>
            <meta http-equiv="content-type" content="text/html; charset=utf-8" />            
        </head>
        <body>
        <form id="paymentform" action="<?php print pm_obmenkaua::URL; ?>" name = "paymentform" method = "post">
        <?php
            foreach ( $data as $key => $value) :
        ?>
                <input type="hidden" name="<?php echo $key; ?>" value="<?php echo htmlspecialchars($value); ?>">
        <?php
            endforeach;
			//die();
        ?>
        </form>        
        <?php print _JSHOP_REDIRECT_TO_PAYMENT_PAGE ?>
        <br>
        <script type="text/javascript">document.getElementById('paymentform').submit();</script>
        </body>
        </html>
        <?php
        die();

	}
    function checkTransaction($pmconfig, $order, $rescode)
    {
        //       
        $this->loadLanguageFile();

        $callback = $_REQUEST;



        $paymentInfo = $this->isPaymentValid($callback, $pmconfig, $order);

        return $paymentInfo;
    }


    function curl_request($response, $pmconfig, $order){


        list($orderId,) = explode(self::ORDER_SEPARATOR, $response['order_id']);

        if ($orderId != $order->order_id) {
            return array(0, OBMENKAUA_UNKNOWN_ERROR);
        }

        if ($pmconfig['obmenkaua_merchant_id'] != $response['obmenkaua_merchant_id']) {
            return array(0, OBMENKAUA_MERCHANT_DATA_ERROR);
        }


        $order_number = $order->order_id;

        $order_body = '{"payment_id":"'.$order_number.'"}';

        $secret = $pmconfig['obmenkaua_secret_key'];

        $DPAY_CLIENT = $pmconfig['obmenkaua_merchant_id'];

        $DPAY_SECURE = base64_encode(md5($secret  . base64_encode(sha1( $order_body, true)) . $secret , true));

        $order = array();

        // create & initialize a curl session
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://acquiring_api.obmenka.ua/api/einvoice/status");

        curl_setopt($curl, CURLOPT_POSTFIELDS, $order_body);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'DPAY_CLIENT:'. $DPAY_CLIENT,
            'DPAY_SECURE:'. $DPAY_SECURE

        ]);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        $result = json_decode ($output, true);
        print_r ($output);
        $mb_data['payment_status'] = $result['status'];


        /*
     CREATED - поручение создано, 1
     PAIN - в процессе списания, 1
     FINISHED - средства списаны, 6
     PAYIN_ERROR - списать средства не удалось. Само описание находится в блоке error. 1
     CANCELED - оплата более не ожидается, 3
     PAYED_RECALC - счет оплачен, но сумма возмещения пересчитана, 4
     FAILED - оплата не удалась. ПРИСУТСТВУЕТ ТОЛЬКО В СЧЕТАХ, СОЗДАННЫХ В ТЕСТОВОМ РЕЖИМЕ
     */





        if (strcmp ($mb_data['payment_status'], 'FINISHED') == 0) {

            return array(1, '');
        } elseif ((strcmp ($mb_data['payment_status'], 'Pending') == 0) || (strcmp ($mb_data['payment_status'], 'PAYIN') == 0)

        || (strcmp ($mb_data['payment_status'], 'CREATED') == 0)  ||  (strcmp ($mb_data['payment_status'], 'PAYIN_ERROR') == 0)
       || (strcmp ($mb_data['payment_status'], 'FAILED') == 0) ) {
            return array(2, '');

        }
        elseif ((strcmp ($mb_data['payment_status'], 'CANCELED') == 0) ) {
            return array(3, '');
        }else{
            return array(0, '');

        }






        return   $mb_data['payment_status'] ;
    }

    function isPaymentValid($response, $pmconfig, $order)
    {
        list($orderId,) = explode(self::ORDER_SEPARATOR, $response['order_id']);

        if ($orderId != $order->order_id) {
            return array(0, OBMENKAUA_UNKNOWN_ERROR);
        }
		
        if ($pmconfig['obmenkaua_merchant_id'] != $response['obmenkaua_merchant_id']) {
            return array(0, OBMENKAUA_MERCHANT_DATA_ERROR);
        }


        if ($response['act'] == 'notify' ){
                $status =  $this->curl_request($response, $pmconfig, $order);
                 return $status;
            }

        $status_text = array (
            'OBMENKAUA_ORDER_INVALID',
            'OBMENKAUA_ORDER_PENDING',
            'OBMENKAUA_ORDER_CONFIRMED',
            'OBMENKAUA_ORDER_CANCELLED',
            'OBMENKAUA_ORDER_REFUNDED',
            'OBMENKAUA_ORDER_APPROVED',
            'OBMENKAUA_ORDER_APPROVED',
            'OBMENKAUA_ORDER_APPROVED'
        );

        if ($response['act'] == 'finish' ) {


          if ($order->order_status == 1){
              JFactory::getApplication()->enqueueMessage(OBMENKAUA_ORDER_PENDING . $response['order_id']);
              return array(2, OBMENKAUA_ORDER_PENDING . $response['order_id']);
          }

            if ($order->order_status == 6){
                JFactory::getApplication()->enqueueMessage(OBMENKAUA_ORDER_APPROVED. $response['order_id']);
                return array(1, OBMENKAUA_ORDER_APPROVED . $response['order_id']);
            }

            if ($order->order_status == 3){
                JFactory::getApplication()->enqueueMessage(OBMENKAUA_ORDER_CANCELLED. $response['order_id']);
                return array(3, OBMENKAUA_ORDER_CANCELLED . $response['order_id']);
            }


        }
    }


    function getUrlParams($forby_config){
        $params = array();
        $input = JFactory::$application->input;
        $params['order_id'] = $input->getInt('order_id', null);
        $params['hash'] = "";
        $params['checkHash'] = 0;
        $params['checkReturnParams'] = 1;
        return $params;
    }

	function fixOrderTotal($order){
        $total = $order->order_total;
       /*
        if ($order->currency_code_iso=='HUF'){
            $total = round($total);
        }else{
            $total = number_format($total, 2, '.', '');
        }
       */
    return $total;
    }
}
?>